(function($) {
    'use strict';

    $(document).ready(function() {
        qodeRestaurantDatePicker();
        qodefReservationFormTrigger();
    });

    $(document).on( "qodeAjaxPageLoad",function(){
        qodeRestaurantDatePicker();
        qodefReservationFormTrigger();
    });

    $(window).on('load', function (){
        qodeInitElementorReservationForm();
    });

    function qodeRestaurantDatePicker() {
        var datepicker = $('.qode-ot-date');

        if(datepicker.length) {
            datepicker.each(function() {
                $(this).datepicker({
                    prevText: '<span class="arrow_carrot-left"></span>',
                    nextText: '<span class="arrow_carrot-right"></span>',
                    dateFormat: 'M d, yy'
                });
            });
        }
    };

    function qodefReservationFormTrigger() {
        var $form = $('.qode-rf');

        $form.on('submit', function (e) {
            e.preventDefault();

            var inputValues = $form.serializeArray(),
                datetime = '';

            $.each(inputValues, function () {
                var $input = $(this)[0],
                    inputName = $input.name;

                if (inputName === 'date' || inputName === 'time') {
                    datetime += ' ' + $input.value;
                }
            });

            if (datetime.length) {
                var date = new Date(datetime),
                    formattedDate = date.getFullYear() + '-' + (parseInt(date.getMonth(), 10) < 10 ? '0' : '') + (parseInt(date.getMonth(), 10) + 1) + '-' + (parseInt(date.getDate(), 10) < 10 ? '0' : '') + date.getDate() + 'T' + (parseInt(date.getHours(), 10) + 1) + ':' + date.getMinutes() + (parseInt(date.getMinutes(), 10) == 30 ? '' : '0');
                $form.find('[name="datetime"]').val(formattedDate);
            }

            window.open($form.attr('action') + '?' + $form.serialize(), '_blank');
        });
    };

    function qodeInitElementorReservationForm(){
        $j(window).on('elementor/frontend/init', function () {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/qode_reservation_form.default', function() {
                qodeRestaurantDatePicker();
                qodefReservationFormTrigger();
            } );
        });
    }
})(jQuery)