<?php

class StockholmQodeRestaurantElementorReservationForm extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_reservation_form';
    }

    public function get_title() {
        return esc_html__( 'Reservation Form', 'select-restaurant' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-reservation-form';
    }

    public function get_categories() {
        return [ 'select-restaurant' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'select-restaurant' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'open_table_id',
            [
                'label' => esc_html__('OpenTable ID', 'select-restaurant'),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
        
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
        
        echo stockholm_qode_restaurant_get_template_part('modules/shortcodes/reservation-form/templates/reservation-form', '', $params, true);
    }
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmQodeRestaurantElementorReservationForm() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmQodeRestaurantElementorReservationForm() );
}