<?php

class StockholmQodeRestaurantElementorWorkingHours extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_working_hours';
    }

    public function get_title() {
        return esc_html__( 'Working Hours', 'select-restaurant' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-working_hours';
    }

    public function get_categories() {
        return [ 'select-restaurant' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'select-restaurant' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'items_title_tag',
            [
                'label' => esc_html__('Items Title Tag', 'select-restaurant'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag( false ),
                'default' => 'h6'
            ]
        );
	
	    $this->add_control(
		    'color',
		    [
			    'label' => esc_html__('Color', 'select-restaurant'),
			    'type' => \Elementor\Controls_Manager::COLOR
		    ]
	    );

        $this->end_controls_section();

        // Add predefined developer tab content for each shortcode element
        $this->start_controls_section(
            'developer_tools',
            [
                'label' => esc_html__( 'Developer Tools', 'stockholm-restaurant' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'shortcode_snippet',
            [
                'label'   => esc_html__( 'Show Shortcode Snippet', 'stockholm-restaurant' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'no',
                'options' => stockholm_qode_get_yes_no_select_array()
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $params['working_hours']  = $this->getWorkingHours();
	    $params['holder_classes'] = $this->getHolderClasses($params);
	    $params['holder_styles']  = $this->getHolderStyles($params);
	    $params['item_styles']	  = $this->getItemStyles($params);

        if( ! empty( $params['shortcode_snippet'] ) && $params['shortcode_snippet'] == 'yes' ){
            echo $this->get_shortcode_snippet( $params );
        } else{
            echo stockholm_qode_restaurant_get_template_part('modules/shortcodes/working-hours/templates/working-hours-template', '', $params, true);
        }
    }

    private function get_shortcode_snippet( $params ) {
        $atts = array();

        if ( empty( $this ) || ! is_object( $this ) ) {
            return '';
        }

        if ( ! empty( $params ) ) {
            foreach ( $params as $key => $value ) {
                if ( is_array( $value ) || $key === 'shortcode_snippet' ) {
                    continue;
                }

                if( empty( $value ) || $value == '' ){
                    continue;
                }

                $atts[] = $key . '="' . esc_attr( $value ) . '"';
            }
        }

        return sprintf( '<textarea class="qode-shortcode-snipper-holder" rows="3" readonly>[%s %s]</textarea>',
            'qode_working_hours',
            implode( ' ', $atts )
        );
    }
	
	private function getWorkingHours() {
		$workingHours = array();
		
		if(stockholm_qode_restaurant_theme_installed()) {
			//monday
			if(stockholm_qode_options()->getOptionValue('wh_monday_from') !== '') {
				$workingHours['monday']['label'] = esc_html__('Monday', 'select-restaurant');
				$workingHours['monday']['from']  = stockholm_qode_options()->getOptionValue('wh_monday_from');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_monday_to') !== '') {
				$workingHours['monday']['to'] = stockholm_qode_options()->getOptionValue('wh_monday_to');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_monday_closed') !== '') {
				$workingHours['monday']['closed'] = stockholm_qode_options()->getOptionValue('wh_monday_closed');
			}
			
			//tuesday
			if(stockholm_qode_options()->getOptionValue('wh_tuesday_from') !== '') {
				$workingHours['tuesday']['label'] = esc_html__('Tuesday', 'select-restaurant');
				$workingHours['tuesday']['from']  = stockholm_qode_options()->getOptionValue('wh_tuesday_from');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_tuesday_to') !== '') {
				$workingHours['tuesday']['to'] = stockholm_qode_options()->getOptionValue('wh_tuesday_to');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_tuesday_closed') !== '') {
				$workingHours['tuesday']['closed'] = stockholm_qode_options()->getOptionValue('wh_tuesday_closed');
			}
			
			//wednesday
			if(stockholm_qode_options()->getOptionValue('wh_wednesday_from') !== '') {
				$workingHours['wednesday']['label'] = esc_html__('Wednesday', 'select-restaurant');
				$workingHours['wednesday']['from']  = stockholm_qode_options()->getOptionValue('wh_wednesday_from');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_wednesday_to') !== '') {
				$workingHours['wednesday']['to'] = stockholm_qode_options()->getOptionValue('wh_wednesday_to');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_wednesday_closed') !== '') {
				$workingHours['wednesday']['closed'] = stockholm_qode_options()->getOptionValue('wh_wednesday_closed');
			}
			
			//thursday
			if(stockholm_qode_options()->getOptionValue('wh_thursday_from') !== '') {
				$workingHours['thursday']['label'] = esc_html__('Thursday', 'select-restaurant');
				$workingHours['thursday']['from']  = stockholm_qode_options()->getOptionValue('wh_thursday_from');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_thursday_to') !== '') {
				$workingHours['thursday']['to'] = stockholm_qode_options()->getOptionValue('wh_thursday_to');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_thursday_closed') !== '') {
				$workingHours['thursday']['closed'] = stockholm_qode_options()->getOptionValue('wh_thursday_closed');
			}
			
			//friday
			if(stockholm_qode_options()->getOptionValue('wh_friday_from') !== '') {
				$workingHours['friday']['label'] = esc_html__('Friday', 'select-restaurant');
				$workingHours['friday']['from']  = stockholm_qode_options()->getOptionValue('wh_friday_from');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_friday_to') !== '') {
				$workingHours['friday']['to'] = stockholm_qode_options()->getOptionValue('wh_friday_to');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_friday_closed') !== '') {
				$workingHours['friday']['closed'] = stockholm_qode_options()->getOptionValue('wh_friday_closed');
			}
			
			//saturday
			if(stockholm_qode_options()->getOptionValue('wh_saturday_from') !== '') {
				$workingHours['saturday']['label'] = esc_html__('Saturday', 'select-restaurant');
				$workingHours['saturday']['from']  = stockholm_qode_options()->getOptionValue('wh_saturday_from');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_saturday_to') !== '') {
				$workingHours['saturday']['to'] = stockholm_qode_options()->getOptionValue('wh_saturday_to');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_saturday_closed') !== '') {
				$workingHours['saturday']['closed'] = stockholm_qode_options()->getOptionValue('wh_saturday_closed');
			}
			
			//sunday
			if(stockholm_qode_options()->getOptionValue('wh_sunday_from') !== '') {
				$workingHours['sunday']['label'] = esc_html__('Sunday', 'select-restaurant');
				$workingHours['sunday']['from']  = stockholm_qode_options()->getOptionValue('wh_sunday_from');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_sunday_to') !== '') {
				$workingHours['sunday']['to'] = stockholm_qode_options()->getOptionValue('wh_sunday_to');
			}
			
			if(stockholm_qode_options()->getOptionValue('wh_sunday_closed') !== '') {
				$workingHours['sunday']['closed'] = stockholm_qode_options()->getOptionValue('wh_sunday_closed');
			}
		}
		
		return $workingHours;
	}
	
	private function getHolderClasses($params) {
		$classes = array('qode-working-hours-holder');
		
		if(isset($params['enable_frame']) && $params['enable_frame'] === 'yes') {
			$classes[] = 'qode-wh-with-frame';
		}
		
		if(isset($params['bg_image']) && $params['bg_image'] !== '') {
			$classes[] = 'qode-wh-with-bg-image';
		}
		
		return $classes;
	}
	
	private function getHolderStyles($params) {
		$styles = array();
		
		if(isset($params['bg_image']) && $params['bg_image'] !== '') {
			$bg_url = wp_get_attachment_url($params['bg_image']);
			
			if(!empty($bg_url)) {
				$styles[] = 'background-image: url('.$bg_url.')';
			}
		}
		
		return $styles;
	}
	private function getItemStyles($params) {
		$styles = array();
		
		if(isset($params['color']) && $params['color'] !== '') {
			$styles[] = 'color: '.$params['color'];
		}
		
		return $styles;
	}
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmQodeRestaurantElementorWorkingHours() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmQodeRestaurantElementorWorkingHours() );
}