<?php

class StockholmCoreElementorCallToAction extends \Elementor\Widget_Base{
	public function get_name() {
		return 'call_to_action';
	}
	
	public function get_title() {
		return esc_html__( 'Call to Action', 'stockholm-core' );
	}
	
	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-call-to-action';
	}
	
	public function get_categories() {
		return [ 'select' ];
	}
	
	protected function register_controls(){
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'full_width',
			[
				'label' => esc_html__( 'Full Width', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_yes_no_select_array()
			]
		);
		
		$this->add_control(
			'content_in_grid',
			[
				'label' => esc_html__( 'Content in grid', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_yes_no_select_array(),
				'condition' => [
					'full_width' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'type',
			[
				'label' => esc_html__( 'Type', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'normal'    => esc_html__( 'Normal', 'stockholm-core' ),
					'with_icon' => esc_html__( 'With Icon', 'stockholm-core' )
				]
			]
		);
		
		stockholm_qode_icon_collections()->getElementorParamsArray($this, array('type' => 'with_icon'), '', true);
		
		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( "Icon Size (px)", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'type' => 'with_icon'
				]
			]
		);
		
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( "Icon Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => 'with_icon'
				]
			]
		);
		
		$this->add_control(
			'custom_icon',
			[
				'label' => esc_html__( 'Custom Icon', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'type' => 'with_icon'
				]
			]
		);
		
		$this->add_control(
			'content',
			[
				'label' => esc_html__( "Content", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => "<p>".esc_html__( 'This is custom text content for shortcode element', 'stockholm-core' )."</p>"
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'design',
			[
				'label' => esc_html__( 'Design Options', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'background_color',
			[
				'label' => esc_html__( 'Background Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);
		
		$this->add_control(
			'border_color',
			[
				'label' => esc_html__( 'Border Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);
		
		$this->add_control(
			'box_padding',
			[
				'label' => esc_html__( 'Box Padding (top right bottom left) px', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default padding is 60px 0 60px 0', 'stockholm-core' )
			]
		);
		
		$this->add_control(
			'text_size',
			[
				'label' => esc_html__( 'Default Text Font Size (px)', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Font size for p tag', 'stockholm-core' )
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'button_options',
			[
				'label' => esc_html__( 'Button Options', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'show_button',
			[
				'label' => esc_html__( 'Show Button', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_yes_no_select_array()
			]
		);
		
		$this->add_control(
			'button_size',
			[
				'label' => esc_html__( "Button Size", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					''          => esc_html__( 'Default', 'stockholm-core' ),
					'small'     => esc_html__( 'Small', 'stockholm-core' ),
					'medium'    => esc_html__( 'Medium', 'stockholm-core' ),
					'large'     => esc_html__( 'Large', 'stockholm-core' ),
					'big_large' => esc_html__( 'Huge', 'stockholm-core' )
				],
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( "Button Text", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'button_link',
			[
				'label' => esc_html__( "Button Link", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'button_target',
			[
				'label' => esc_html__( "Button Target", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => stockholm_qode_get_link_target_array(),
				'default' => '_self',
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'button_text_color',
			[
				'label' => esc_html__( "Button text color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'button_hover_text_color',
			[
				'label' => esc_html__( "Button hover text color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'button_background_color',
			[
				'label' => esc_html__( "Button Background Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'button_hover_background_color',
			[
				'label' => esc_html__( "Button Hover Background Color", 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'button_border_color',
			[
				'label' => esc_html__( 'Button Border Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'button_hover_border_color',
			[
				'label' => esc_html__( 'Button Hover Border Color', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_button' => 'yes'
				]
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render(){
		$params = $this->get_settings_for_display();
		$params['icon'] = stockholm_qode_icon_collections()->getElementorIconFromIconPack( $params );
		$params['text_color'] = '';
		
		
		echo stockholm_qode_get_shortcode_template_part('templates/call-to-action', '_call-to-action', '', $params);
	}
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorCallToAction() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorCallToAction() );
}