<?php

class StockholmCoreElementorPieChartDoughnut extends \Elementor\Widget_Base{
    public function get_name() {
        return 'pie_chart_doughnut';
    }

    public function get_title() {
        return esc_html__( "Pie Chart 3 (Doughnut)", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-pie-chart-doughnut';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'width',
            [
                'label' => esc_html__( "Width", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '120'
            ]
        );

        $this->add_control(
            'height',
            [
                'label' => esc_html__( "Height", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '120'
            ]
        );

        $this->add_control(
            'color',
            [
                'label' => esc_html__( "Legend Text Color", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::COLOR
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__( "Content", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( '15,#e6ae48,Legend One; 35,#f5b94d,Legend Two; 50,#fdc050,Legend Three', 'stockholm-core' ),
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/pie-chart-doughnut', '_pie-chart-doughnut', '', $params);
    }

}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorPieChartDoughnut() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorPieChartDoughnut() );
}