<?php

class StockholmCoreElementorPortfolioSlider extends \Elementor\Widget_Base{
    public function get_name() {
        return 'portfolio_slider';
    }

    public function get_title() {
        return esc_html__( "Portfolio Slider", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-portfolio-slider';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => esc_html__( "Order By", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => '',
                    'menu_order' => esc_html__( 'Menu Order', 'stockholm-core' ),
                    'title'      => esc_html__( 'Title', 'stockholm-core' ),
                    'date'       => esc_html__( 'Date', 'stockholm-core' )
                ],
                'default' => 'menu_order'
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__( "Order", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_query_order_array( true ),
                'default' => 'ASC'
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__( "Number", 'stockholm-core' ),
                "description" => esc_html__( "Number of portolios on page (-1 is all)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '-1'
            ]
        );

        $this->add_control(
            'number_of_columns',
            [
                'label' => esc_html__( "Number of Columns", 'stockholm-core' ),
                "description" => esc_html__( "Number of columns for portfolio slider", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                	'' => esc_html__('Default ( grid based )', 'stockholm-core'),
                	'2' => '2',
                	'3' => '3',
                	'4' => '4'
                ],
                'default' => ''
            ]
        );

        $this->add_control(
            'category',
            [
                'label' => esc_html__( "Category", 'stockholm-core' ),
                "description" => esc_html__( "Category Slug (leave empty for all)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );

        $this->add_control(
            'selected_projects',
            [
                'label' => esc_html__( "Selected Projects", 'stockholm-core' ),
                "description" => esc_html__( "Selected Projects (leave empty for all, delimit by comma)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
	
	    $this->add_control(
		    'disable_link',
		    [
			    'label' => esc_html__( "Disable Portfolio Link", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true, true),
			    'default' => 'no',
			    "description" => esc_html__( "Default value is No", 'stockholm' )
		    ]
	    );
        
        $this->add_control(
            'lightbox',
            [
                'label' => esc_html__( "Show Lightbox", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_yes_no_select_array(true, true),
                'default' => 'yes',
                "description" => esc_html__( "Default value is Yes", 'stockholm' )
            ]
        );
	
	    $this->add_control(
		    'show_like',
		    [
			    'label' => esc_html__( "Show Like", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true, true),
			    'default' => 'yes',
			    "description" => esc_html__( "Default value is Yes", 'stockholm' )
		    ]
	    );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( "Title Tag", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag(false),
                'default' => 'h3'
            ]
        );
        
        $this->add_control(
            'image_size',
            [
                'label' => esc_html__( "Image size", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'Default', 'stockholm-core' ),
                    'full' => esc_html__( 'Original Size', 'stockholm-core' ),
                    'square' => esc_html__( 'Square', 'stockholm-core' ),
                    'landscape' => esc_html__( 'Landscape', 'stockholm-core' ),
                    'portrait' => esc_html__( 'Portrait', 'stockholm-core' ),
                ],
                'default' => 'square'
            ]
        );

        $this->add_control(
            'enable_navigation',
            [
                'label' => esc_html__( "Enable prev/next navigation?", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );

        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();

        echo stockholm_qode_get_shortcode_template_part('templates/portfolio-slider', '_portfolio-slider', '', $params);
    }

}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorPortfolioSlider() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorPortfolioSlider() );
}
