<?php

class StockholmCoreHorizontalLayout extends \Elementor\Widget_Base{
	public function get_name() {
		return 'qode_horizontal_layout';
	}

	public function get_title() {
		return esc_html__( "Horizontal Layout", 'stockholm-core' );
	}

	public function get_icon() {
		return 'stockholm-elementor-custom-icon stockholm-elementor-horizontal-layout';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'stockholm-core' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'intro_title',
			[
				'label' => esc_html__( 'Intro Title', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'intro_button_link',
			[
				'label' => esc_html__( 'Intro Button Link', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'intro_button_text',
			[
				'label' => esc_html__( 'Intro Button Text', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'intro_button_link!' => ''
				]
			]
		);

		$this->add_control(
			'content_background_color',
			[
				'label' => esc_html__( 'Content Background Color', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::COLOR
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'image_small_1',
			[
				'label' => esc_html__( 'Small Image 1', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'image_small_1_link',
			[
				'label' => esc_html__( 'Small Image 1 Link', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'image_small_2',
			[
				'label' => esc_html__( 'Small Image 2', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'image_small_2_link',
			[
				'label' => esc_html__( 'Small Image 2 Link', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'target',
			[
				'label' => esc_html__( 'Target', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'_blank' => esc_html__( 'Blank', 'stockholm-core'),
					'_self' => esc_html__( 'Self', 'stockholm-core'),
				],
				'default' => '_blank'
			]
		);

		$repeater->add_control(
			'text',
			[
				'label' => esc_html__( 'Text', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'text_link',
			[
				'label' => esc_html__( 'Text Link', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'text_target',
			[
				'label' => esc_html__( 'Text Target', 'stockholm-core'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'_blank' => esc_html__( 'Blank', 'stockholm-core'),
					'_self' => esc_html__( 'Self', 'stockholm-core'),
				],
				'default' => '_blank'
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'stockholm-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => esc_html__('Horizontal Layout Item'),
			]
		);

		$this->end_controls_section();
	}

	protected function render(){
		$params = $this->get_settings_for_display();

		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['item_classes']   = $this->getItemClasses( $params );
		$params['this_object']    = $this;
		$params['animation_data'] = $this->getAnimationData( $params );
		$params['is_elementor'] = true;

		echo stockholm_qode_get_shortcode_template_part( 'templates/horizontal-layout', 'horizontal-layout', '', $params );
	}

	private function getAnimationData( $atts ) {
		$animation_data = array();

		$animation_data[] = ( ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes') ? 'data-splitting' : '';

		return implode( ' ', $animation_data );
	}

	private function getHolderClasses( $atts ) {
		$holder_classes[] = 'qodef-horizontal-layout';
		$holder_classes[] = ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes' ? 'qodef--has-appear qodef--splitting' : '';

		return implode( ' ', $holder_classes );
	}

	private function getItemClasses( $atts ) {
		$item_classes = array();

		$item_classes[] = ! empty ( $atts['enable_appear'] ) && $atts['enable_appear'] == 'yes' ? 'qodef--has-appear qodef--has-horizontal-appear qodef--splitting' : '';

		return implode( ' ', $item_classes  );
	}
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreHorizontalLayout() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreHorizontalLayout() );
}
