<?php

class StockholmCoreElementorPortfolioList extends \Elementor\Widget_Base{
    public function get_name() {
        return 'portfolio_list';
    }

    public function get_title() {
        return esc_html__( "Portfolio List", 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-portfolio-list';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
	
	    $this->add_control(
		    'type',
		    [
			    'label' => esc_html__( "Type", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
			    	'standard'              => esc_html__( 'Standard', 'stockholm-core' ),
			    	'standard_no_space'     => esc_html__( 'Standard No Space', 'stockholm-core' ),
			    	'hover_text'            => esc_html__( 'Gallery Text', 'stockholm-core' ),
			    	'hover_text_no_space'   => esc_html__( 'Gallery No Space', 'stockholm-core' ),
				    'masonry'               => esc_html__( 'Masonry', 'stockholm-core' ),
				    'masonry_with_space'    => esc_html__( 'Pinterest', 'stockholm-core' ),
				    'justified_gallery'     => esc_html__( 'Justified Gallery', 'stockholm-core' ),
                    'split'                 => esc_html__( 'Split', 'stockholm-core' ),
			    ],
			    'default' => 'standard'
		    ]
	    );

        $this->add_control(
            'masonry_with_predefined_columns',
            [
                'label' => esc_html__( "Predefined Masonry Columns", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_yes_no_select_array(false, true),
                'default' => 'yes',
                'condition' => [
                    'type' => 'masonry'
                ]
            ]
        );

        $this->add_control(
            'masonry_columns',
            [
                'label' => esc_html__( "Masonry Columns", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'one' => esc_html__('One', 'stockholm-core'),
                    'two' => esc_html__('Two', 'stockholm-core'),
                    'three' => esc_html__('Three', 'stockholm-core'),
                    'four' => esc_html__('Four', 'stockholm-core'),
                    'five' => esc_html__('Five', 'stockholm-core'),
                    'six' => esc_html__('Six', 'stockholm-core'),
                ),
                'default' => 'three',
                'condition' => [
                    'masonry_with_predefined_columns' => 'no',
                ]
            ]
        );
	
	    $this->add_control(
		    'masonry_space',
		    [
			    'label' => esc_html__( "Space Between Masonry", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(),
			    'default' => 'no',
			    'condition' => [
			    	'type' => 'masonry',
                    'masonry_with_predefined_columns' => 'yes'
			    ]
		    ]
	    );

	    $this->add_control(
		    'masonry_columns_space',
		    [
			    'label' => esc_html__( "Space Between Masonry Columns", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => array(
			        'no' => esc_html__( 'No', 'stockholm-core' ),
			        'tiny' => esc_html__( 'Tiny', 'stockholm-core' ),
			        'small' => esc_html__( 'Small', 'stockholm-core' ),
			        'normal' => esc_html__( 'Normal', 'stockholm-core' ),
			        'medium' => esc_html__( 'Medium', 'stockholm-core' ),
			        'large' => esc_html__( 'Large', 'stockholm-core' ),
                ),
			    'default' => 'no',
			    'condition' => [
			    	'type' => 'masonry',
                    'masonry_with_predefined_columns' => 'no'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'pinterest_space',
		    [
			    'label' => esc_html__( "Space Between Pinterest", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(),
			    'default' => 'no',
			    'condition' => [
				    'type' => 'masonry_with_space'
			    ]
		    ]
	    );

	    $this->add_control(
		    'pinterest_image_size',
		    [
			    'label' => esc_html__( "Image Size For Pinterest", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
                    'portfolio_masonry_with_space' => esc_html__('Default / Predefined', 'stockholm-core'),
                    'full' => esc_html__('Full / Original', 'stockholm-core'),
                ],
			    'default' => 'portfolio_masonry_with_space',
			    'condition' => [
				    'type' => 'masonry_with_space'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'portfolio_loading_type',
		    [
			    'label' => esc_html__( "Loading Type", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''  => esc_html__( 'Default', 'stockholm-core' ),
				    'appear_from_bottom' => esc_html__( 'Appear From Bottom', 'stockholm-core' )
			    ],
			    'default' => '',
			    'condition' => [
				    'type' => array( 'masonry_with_space', 'masonry' ),
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'parallax_item_speed',
		    [
			    'label' => esc_html__( "Parallax Item Speed", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    "description" => esc_html__( 'This option only takes effect on portfolio items on which Set Masonry Item in Parallax is set to Yes default value is 0.3', 'stockholm-core' ),
			    'default' => '0.3',
			    'condition' => [
				    'masonry_space' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'parallax_item_offset',
		    [
			    'label' => esc_html__( "Parallax Item Offset", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    "description" => esc_html__( 'This option only takes effect on portfolio items on which Set Masonry Item in Parallax is set to Yes default value is 0', 'stockholm-core' ),
			    'default' => '0',
			    'condition' => [
				    'masonry_space' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'hover_type',
		    [
			    'label' => esc_html__( "Hover Type", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'default_hover'             => esc_html__( 'Default', 'stockholm-core' ),
				    'standard_hover'            => esc_html__( 'Standard', 'stockholm-core' ),
				    'elegant_hover'             => esc_html__( 'Elegant Without Icons', 'stockholm-core' ),
				    'move_from_left'            => esc_html__( 'Move from Left', 'stockholm-core' ),
				    'overlapping_title_hover'   => esc_html__( 'Overlapping Title', 'stockholm-core' ),
				    'no-effect'                 => esc_html__( "No Effect", 'stockholm-core' )
			    ],
			    'default' => 'default_hover',
			    'condition' => [
				    'type' => array( 'hover_text', 'hover_text_no_space', 'masonry' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'pinterest_hover_type',
		    [
			    'label' => esc_html__( "Pinterest Hover Type", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    '' => esc_html__( 'Default', 'stockholm-core' ),
				    'info_on_hover' => esc_html__( 'Info on Hover', 'stockholm-core' )
			    ],
			    'default' => '',
			    'condition' => [
				    'type' => 'masonry_with_space'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'box_background_color',
		    [
			    'label' => esc_html__( "Box Background Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'type' => array( 'standard', 'standard_no_space', 'masonry_with_space' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'box_border',
		    [
			    'label' => esc_html__( "Box Border", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(),
			    'default' => 'no',
			    'condition' => [
				    'type' => array( 'standard', 'standard_no_space', 'masonry_with_space' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'box_border_width',
		    [
			    'label' => esc_html__( "Box Border Width (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'box_border' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'box_border_color',
		    [
			    'label' => esc_html__( "Box Border Color", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::COLOR,
			    'condition' => [
				    'box_border' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'columns',
		    [
			    'label' => esc_html__( "Columns", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    "" => "",
				    "2" => "2",
				    "3" => "3",
				    "4" => "4",
				    "5" => "5",
				    "6" => "6",
			    ],
			    'condition' => [
				    'type' => array( 'standard', 'standard_no_space', 'hover_text', 'hover_text_no_space', 'masonry_with_space' )
			    ],
			    'default' => '3'
		    ]
	    );
	
	    $this->add_control(
		    'image_size',
		    [
			    'label' => esc_html__( "Image size", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''          => esc_html__( 'Default', 'stockholm-core' ),
				    'full'      => esc_html__( 'Original Size', 'stockholm-core' ),
				    'square'    => esc_html__( 'Square', 'stockholm-core' ),
				    'landscape' => esc_html__( 'Landscape', 'stockholm-core' ),
				    'portrait'  => esc_html__( 'Portrait', 'stockholm-core' ),
			    ],
			    'condition' => [
				    'type' => array( 'standard', 'standard_no_space', 'hover_text', 'hover_text_no_space' )
			    ],
			    'default' => ''
		    ]
	    );
	
	    $this->add_control(
		    'row_height',
		    [
			    'label' => esc_html__( "Row Height (px)", 'stockholm-core' ),
			    "description" => esc_html__( "Targeted row height, which may vary depending on the proportions of the images.", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'type' => 'justified_gallery'
			    ],
			    'default' => '200'
		    ]
	    );
	
	    $this->add_control(
		    'justify_last_row',
		    [
			    'label' => esc_html__( "Last Row Behavior", 'stockholm-core' ),
			    "description" => esc_html__( "Defines whether to justify the last row, align it in a certain way, or hide it.", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'nojustify' => esc_html__( 'Align left', 'stockholm-core' ),
				    'right'     => esc_html__( 'Align right', 'stockholm-core' ),
				    'center'    => esc_html__( 'Align centrally', 'stockholm-core' ),
				    'justify'   => esc_html__( 'Justify', 'stockholm-core' ),
				    'hide'      => esc_html__( 'Hide', 'stockholm-core' ),
			    ],
			    'condition' => [
				    'type' => 'justified_gallery'
			    ],
			    'default' => 'nojustify'
		    ]
	    );
	
	    $this->add_control(
		    'justify_threshold',
		    [
			    'label' => esc_html__( "Justify Threshold (0-1)", 'stockholm-core' ),
			    "description" => esc_html__( "If the last row takes up more than this part of available width, it will be justified despite the defined alignment. Enter 1 to never justify the last row.", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'justify_last_row' => array( 'nojustify', 'right', 'center' )
			    ],
			    'default' => '0.75'
		    ]
	    );

	    $this->add_control(
		    'space_between',
		    [
			    'label' => esc_html__( "Space Between", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'type' => 'justified_gallery'
                ],
			    'default' => '10'
		    ]
	    );
	    
        $this->add_control(
            'order_by',
            [
                'label' => esc_html__( "Order By", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_query_order_by_array( true ),
                'default' => 'menu_order'
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__( "Order", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_query_order_array( true ),
                'default' => 'ASC'
            ]
        );
	
	    $this->add_control(
		    'filter',
		    [
			    'label' => esc_html__( "Filter", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true,true),
			    'default' => 'no',
                'condition' => array(
                    'type!' => 'split'
                )
		    ]
	    );
	
	    $this->add_control(
		    'filter_position',
		    [
			    'label' => esc_html__( "Filter Position", 'stockholm-core' ),
			    "description" => esc_html__( "Default value is Top", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'top'   => esc_html__( 'Top', 'stockholm-core' ),
				    'left'  => esc_html__( 'Left', 'stockholm-core' )
			    ],
			    'default' => 'top',
                'condition' => [
                    'filter' => 'yes'
                ]
		    ]
	    );
	
	    $this->add_control(
		    'filter_order_by',
		    [
			    'label' => esc_html__( "Filter Order By", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'name'  => esc_html__( 'Name', 'stockholm-core' ),
				    'count' => esc_html__( 'Count', 'stockholm-core' ),
				    'id'    => esc_html__( 'ID', 'stockholm-core' ),
				    'slug'  => esc_html__( 'Slug', 'stockholm-core' ),
			    ],
			
			    'description' => esc_html__( 'Default value is Name', 'stockholm-core' ),
			    'default' => 'name',
			    'condition' => [
				    'filter' => 'yes'
			    ],
		    ]
	    );
	
	    $this->add_control(
		    'disable_filter_title',
		    [
			    'label' => esc_html__( "Disable Filter Title", 'stockholm-core' ),
			    "description" => esc_html__( "Default value is No", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true,true),
			    'default' => 'no',
			    'condition' => [
				    'filter' => 'yes'
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'filter_title_text',
		    [
			    'label' => esc_html__( "Filter Title Text", 'stockholm-core' ),
			    "description" => esc_html__( "Enter custom filter title text", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'disable_filter_title' => array( '', 'no' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'filter_align',
		    [
			    'label' => esc_html__( "Filter Align", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    'left_align'    => esc_html__( 'Left', 'stockholm-core' ),
				    'center_align'  => esc_html__( 'Center', 'stockholm-core' ),
				    'right_align'   => esc_html__( 'Right', 'stockholm-core' )
			    ],
			    'condition' => [
				    'filter' => 'yes'
			    ]
			    
		    ]
	    );
	
	    $this->add_control(
		    'disable_link',
		    [
			    'label' => esc_html__( "Disable Portfolio Link", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true, true),
			    'default' => 'no',
			    "description" => esc_html__( "Default value is No", 'stockholm' ),
			    'condition' => [
				    'type' => array( 'standard', 'standard_no_space', 'hover_text', 'hover_text_no_space', 'masonry', 'masonry_with_space' )
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'lightbox',
		    [
			    'label' => esc_html__( "Show Lightbox", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true, true),
			    'default' => 'yes',
			    "description" => esc_html__( "Default value is Yes", 'stockholm' ),
                'condition' => array(
                    'type!' => 'split'
                )
		    ]
	    );
	
	    $this->add_control(
		    'show_like',
		    [
			    'label' => esc_html__( "Show Like", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true, true),
			    'default' => 'yes',
			    "description" => esc_html__( "Default value is Yes", 'stockholm' ),
                'condition' => array(
                    'type!' => 'split'
                )
		    ]
	    );
	
	    $this->add_control(
		    'show_load_more',
		    [
			    'label' => esc_html__( "Show Load More", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(true, true),
			    'default' => 'yes',
			    "description" => esc_html__( "Default value is Yes", 'stockholm' ),
			    'condition' => [
				    'type' => array( 'standard', 'standard_no_space', 'hover_text', 'hover_text_no_space', 'masonry_with_space', 'justified_gallery' )
			    ]
		    ]
	    );
	    
        $this->add_control(
            'number',
            [
                'label' => esc_html__( "Number", 'stockholm-core' ),
                "description" => esc_html__( "Number of portolios on page (-1 is all)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '-1',
                'condition' => [
	                'type' => array( 'standard', 'standard_no_space', 'hover_text', 'hover_text_no_space', 'masonry', 'masonry_with_space', 'justified_gallery' )
                ]
            ]
        );

        $this->add_control(
            'category',
            [
                'label' => esc_html__( "Category", 'stockholm-core' ),
                "description" => esc_html__( "Category Slug (leave empty for all)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => array(
                    'type!' => 'split'
                )
            ]
        );

        $this->add_control(
            'selected_projects',
            [
                'label' => esc_html__( "Selected Projects", 'stockholm-core' ),
                "description" => esc_html__( "Selected Projects (leave empty for all, delimit by comma)", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::TEXT
            ]
        );
        
        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( "Title Tag", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag(false),
                'default' => 'h3',
                'condition' => [
	                'type' => array( 'standard', 'standard_no_space', 'hover_text', 'hover_text_no_space', 'masonry', 'masonry_with_space', 'split' )
                ]
            ]
        );
	
	    $this->add_control(
		    'title_font_size',
		    [
			    'label' => esc_html__( "Title Custom Font Size (px)", 'stockholm-core' ),
			    'type' => \Elementor\Controls_Manager::TEXT,
			    'condition' => [
				    'type' => array( 'standard', 'standard_no_space', 'hover_text', 'hover_text_no_space', 'masonry', 'masonry_with_space' )
			    ]
		    ]
	    );
        
        $this->add_control(
            'text_align',
            [
                'label' => esc_html__( "Text align", 'stockholm-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'left'      => esc_html__( 'Left', 'stockholm-core' ),
                    'center'    => esc_html__( 'Center', 'stockholm-core' ),
                    'right'     => esc_html__( 'Right', 'stockholm-core' )
                ],
                'default' => 'left',
                'condition' => [
	                'type' => array( 'standard', 'standard_no_space', 'masonry_with_space', 'split' )
                ]
            ]
        );
        
        $this->end_controls_section();
    }

    protected function render(){
        $params = $this->get_settings_for_display();
	
	    $params['thisObject'] = $this;
	
	    $params['portfolio_qode_like'] = stockholm_qode_options()->getOptionValue( 'portfolio_qode_like' );
	
	    $params['portfolio_list_hide_category'] = false;
	    if ( stockholm_qode_options()->getOptionValue( 'portfolio_list_hide_category' ) == "yes" ) {
		    $params['portfolio_list_hide_category'] = true;
	    }
	
	    if ( stockholm_qode_options()->getOptionValue( 'portfolio_filter_disable_separator' ) == "yes" ) {
		    $params['portfolio_filter_class'] = "without_separator";
	    } else {
		    $params['portfolio_filter_class'] = "";
	    }
	
	    if ( $params['filter_title_text'] !== '' ) {
		    $params['filter_title'] = $params['filter_title_text'];
	    } else {
		    $params['filter_title'] = esc_html__( 'Sort Portfolio:', 'stockholm-core' );
	    }
	
	    $params['_type_class']                         = '';
	    $params['_portfolio_space_class']              = '';
	    $params['_portfolio_masonry_with_space_class'] = '';
	    $params['_portfolio_masonry_class']            = '';
	    $params['_loading_class']                      = '';
	
	    if ( $params['type'] == "hover_text" ) {
		    $params['_type_class']            = " hover_text";
		    $params['_portfolio_space_class'] = "portfolio_with_space portfolio_with_hover_text";
	    } elseif ( $params['type'] == "standard" || $params['type'] == "masonry_with_space" ) {
		    $params['_type_class']            = " standard";
		    $params['_portfolio_space_class'] = "portfolio_with_space portfolio_standard";
		    if ( $params['type'] == "masonry_with_space" ) {
			    $params['_portfolio_masonry_with_space_class'] = ' masonry_with_space';
		    }
		    if ( $params['pinterest_space'] == "yes" && $params['type'] == "masonry_with_space" ) {
			    $params['_portfolio_masonry_with_space_class'] = 'masonry_with_space pinterest_space';
		    }
	    } elseif ( $params['type'] == "standard_no_space" ) {
		    $params['_type_class']            = " standard_no_space";
		    $params['_portfolio_space_class'] = "portfolio_no_space portfolio_standard";
	    } elseif ( $params['type'] == "hover_text_no_space" ) {
		    $params['_type_class']            = " hover_text no_space";
		    $params['_portfolio_space_class'] = "portfolio_no_space portfolio_with_hover_text";
	    } elseif ( $params['type'] == "justified_gallery" ) {
		    $params['_type_class']            = " justified_gallery";
		    $params['_portfolio_space_class'] = "portfolio_no_space";
	    } elseif ( $params['type'] == "split" ){
            $params['_type_class']            = " qode-pl-split";
            $params['_portfolio_space_class'] = "portfolio_no_space";
            $params['show_load_more'] = 'no';
        }
	
	    $params['filter_position_class'] = $this->getFilterPositionClass( $params );
	
	    //get proper image size
	    switch ( $params['image_size'] ) {
		    case 'landscape':
			    $params['thumb_size_class'] = 'portfolio_landscape_image';
			    break;
		    case 'portrait':
			    $params['thumb_size_class'] = 'portfolio_portrait_image';
			    break;
		    case 'square':
			    $params['thumb_size_class'] = 'portfolio_square_image';
			    break;
		    case 'full':
			    $params['thumb_size_class'] = 'portfolio_full_image';
			    break;
		    default:
			    $params['thumb_size_class'] = 'portfolio_default_image';
			    break;
	    }
	
	    if ( $params['type'] == 'justified_gallery' ) {
		    $params['hover_type'] = " justified_gallery_hover ";
	    }
	
	    if ( $params['portfolio_loading_type'] != "" ) {
		    $params['_loading_class'] = $params['portfolio_loading_type'];
	    }
	
	    if ( $params['type'] == 'masonry_with_space' && $params['pinterest_hover_type'] == "info_on_hover" ) {
		    $params['hover_type'] = " pinterest_info_on_hover ";
	    }
	
	    if ( $params['masonry_space'] == 'yes' ) {
		    $params['_portfolio_masonry_class'] .= 'masonry_extended';
	    }

	    if( ! empty( $params['masonry_columns'] ) ){
	        $params['_portfolio_masonry_class'] .= ' qodef-' . $params['masonry_columns'] . '-columns';
        }

	    if( ! empty( $params['masonry_columns_space'] ) ){
	        $params['_portfolio_masonry_class'] .= ' qodef-' . $params['masonry_columns_space'] . '-space';
        }
	
	    $params['portfolio_box_style']         = "";
	    $params['portfolio_description_class'] = "";
	
	    if ( $params['box_border'] == "yes" || $params['box_background_color'] != "" ) {
		
		    $params['portfolio_box_style'] .= "style=";
		    if ( $params['box_border'] == "yes" ) {
			    $params['portfolio_box_style'] .= "border-style:solid;";
			    if ( $params['box_border_color'] != "" ) {
				    $params['portfolio_box_style'] .= "border-color:" . $params['box_border_color'] . ";";
			    }
			    if ( $params['box_border_width'] != "" ) {
				    $params['portfolio_box_style'] .= "border-width:" . $params['box_border_width'] . "px;";
			    } else {
				    $params['portfolio_box_style'] .= "border-width: 1px;";
			    }
		    }
		    if ( $params['box_background_color'] != "" ) {
			    $params['portfolio_box_style'] .= "background-color:" . $params['box_background_color'] . ";";
		    }
		    $params['portfolio_box_style'] .= "'";
		
		    $params['portfolio_description_class'] .= 'with_padding';
		
		    $params['_portfolio_space_class'] = ' with_description_background';
		
	    }
	
	    if ( $params['text_align'] !== '' ) {
		    $params['portfolio_description_class'] .= ' text_align_' . $params['text_align'];
	    }
	
	    $query_array             = $this->getQueryArray( $params );
	    $query_results           = new \WP_Query( $query_array );
	    $params['query_results'] = $query_results;
	
	    $params['slug_list_'] = "pretty_photo_gallery";
	    $params['title']      = get_the_title();

	    if( $params['type'] == 'masonry' && $params['masonry_with_predefined_columns'] == 'no' ){
            $params['type'] = 'masonry-columns';
        }

        echo stockholm_qode_get_shortcode_template_part( 'templates/portfolio-holder', 'portfolio-list', $params['type'], $params );
    }
	
	public function getQueryArray( $params ) {
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}
		if ( $params['category'] == "" ) {
			$args = array(
				'post_status'    => 'publish',
				'post_type'      => 'portfolio_page',
				'orderby'        => $params['order_by'],
				'order'          => $params['order'],
				'posts_per_page' => $params['number'],
				'paged'          => $paged
			);
		} else {
			$args = array(
				'post_status'        => 'publish',
				'post_type'          => 'portfolio_page',
				'portfolio_category' => $params['category'],
				'orderby'            => $params['order_by'],
				'order'              => $params['order'],
				'posts_per_page'     => $params['number'],
				'paged'              => $paged
			);
		}
		$project_ids = null;
		if ( $params['selected_projects'] != "" ) {
			$project_ids      = explode( ",", $params['selected_projects'] );
			$args['post__in'] = $project_ids;
		}
		
		return $args;
	}
	
	public function getMasonryItemClasses( $params ) {
		$classes = array();
		
		$terms = wp_get_post_terms( get_the_ID(), 'portfolio_category' );
		foreach ( $terms as $term ) {
			$classes[] = "portfolio_category_" . $term->term_id;
		}
		
		$masonry_parallax = get_post_meta( get_the_ID(), "qode_portfolio_masonry_parallax", true );
		if ( $masonry_parallax == "yes" ) {
			$classes[] = "parallax_item";
		}
		
		$masonry_size = get_post_meta( get_the_ID(), "qode_portfolio_type_masonry_style", true );
		$classes[]    = $masonry_size;
		$classes[] = 'qodef-item-space';
		
		return $classes;
	}
	
	public function getItemClasses( $params ) {
		$classes = array();
		
		$terms = wp_get_post_terms( get_the_ID(), 'portfolio_category' );
		foreach ( $terms as $term ) {
			$classes[] = "portfolio_category_" . $term->term_id;
		}
		
		return $classes;
	}
	
	public function getFilterPositionClass( $params ) {
		$classes         = array();
		$filter_position = $params['filter_position'];
		
		switch ( $filter_position ) {
			case 'top':
				$classes[] = 'qode-filter-position-top';
				break;
			case 'left':
				$classes[] = 'qode-filter-position-left';
				break;
			default:
				$classes[] = 'qode-filter-position-top';
				break;
		}
		
		return $classes;
	}
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorPortfolioList() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorPortfolioList() );
}
