<?php

class StockholmCoreElementorSimpleBlogList extends \Elementor\Widget_Base{
    public function get_name() {
        return 'qode_simple_blog_list';
    }

    public function get_title() {
        return esc_html__( 'Simple Blog List', 'stockholm-core' );
    }

    public function get_icon() {
        return 'stockholm-elementor-custom-icon stockholm-elementor-simple-blog-list';
    }

    public function get_categories() {
        return [ 'select' ];
    }

    protected function register_controls(){

        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__( 'General', 'stockholm-core' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'posts_title_tag',
            [
                'label' => esc_html__('Posts Title Tag', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_title_tag( false ),
                'default' => 'h3'
            ]
        );
        
        $this->add_control(
            'excerpt_length',
            [
                'label' => esc_html__('Excerpt Length', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'number_of_columns',
            [
                'label' => esc_html__('Number of Columns', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '3' => '3',
                    '4' => '4',
                    '5' => '5'
                ],
            ]
        );

	    $this->add_control(
		    'read_more_style',
		    [
			    'label' => esc_html__('Read More Style', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''              => esc_html__( 'Default', 'stockholm-core' ),
				    'white'         => esc_html__( 'White', 'stockholm-core' ),
				    'underlined'    => esc_html__( 'Underlined', 'stockholm-core' )
			    ],
			    'default' => ''
		    ]
	    );

	    $this->add_control(
		    'read_more_hover_animation',
		    [
			    'label' => esc_html__('Read More Hover Animation', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => [
				    ''             => esc_html__('Default', 'stockholm-core'),
				    'display-dash' => esc_html__('Display Dash', 'stockholm-core')
			    ],
			    'default' => '',
			    'condition' => [
				    'read_more_style' => ''
			    ]
		    ]
	    );
	
	    $this->add_control(
		    'blog_list_animation',
		    [
			    'label' => esc_html__('Enable Blog List Animation', 'stockholm-core'),
			    'type' => \Elementor\Controls_Manager::SELECT,
			    'options' => stockholm_qode_get_yes_no_select_array(false,false),
			    'default' => 'no'
		    ]
	    );
	    
	    $this->end_controls_section();
	
	    $this->start_controls_section(
		    'query',
		    [
			    'label' => esc_html__( 'Build Query', 'stockholm-core' ),
			    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		    ]
	    );
	    
        $this->add_control(
            'number',
            [
                'label' => esc_html__('Number', 'stockholm-core'),
                'description'	=> esc_html__('Number of blog posts on page (Leave empty for all)', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '-1'
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => esc_html__('Order By', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'date'   => esc_html__('Date', 'stockholm-core'),
                    'title'  => esc_html__('Title', 'stockholm-core')
                ],
                'default' => 'date'
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('Order', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => stockholm_qode_get_query_order_array(),
                'default' => 'DESC'
            ]
        );

        $this->add_control(
            'category',
            [
                'label' => esc_html__('Category', 'stockholm-core'),
                'description'	=> esc_html__('Category Slug (leave empty for all)', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'selected_projects',
            [
                'label' => esc_html__('Selected Posts', 'stockholm-core'),
                'description' => esc_html__('Selected Posts (leave empty for all, delimit by comma)', 'stockholm-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->end_controls_section();
        
    }

    protected function render(){
        $params = $this->get_settings_for_display();

	    $query_args                  = $this->createQueryArgs( $params );
	    $blog_query                  = new \WP_Query( $query_args );
	    $params['blog_query']        = $blog_query;
	    $params['holder_classes']    = $this->holderClasses( $params );
	    $params['read_more_classes'] = $this->readMoreClasses( $params );
        
        echo stockholm_qode_get_shortcode_template_part('templates/simple-blog-list-template', 'simple-blog-list', '', $params);
    }
	
	private function createQueryArgs( $params ) {
		$args = array(
			'post_status'    => 'publish',
			'post_type'      => 'post',
			'orderby'        => $params['order_by'],
			'order'          => $params['order'],
			'posts_per_page' => $params['number']
		);
		
		if ( $params['category'] !== '' ) {
			$args['category_name'] = $params['category'];
		}
		
		if ( $params['selected_projects'] !== '' ) {
			$args['post__in'] = explode( ",", $params['selected_projects'] );
		}
		
		return $args;
	}
	
	private function holderClasses( $params ) {
		$classes = array( 'qode-simple-blog-list' );
		
		if ( $params['number_of_columns'] != '' ) {
			$classes[] = 'qode-sbl-' . $params['number_of_columns'] . '-columns';
		}
		
		if ( $params['blog_list_animation'] == 'yes' ) {
			$classes[] = 'qode-sbl-animated';
		}
		
		return $classes;
	}
	
	private function readMoreClasses( $params ) {
		$classes = array( '' );
		
		if ( $params['read_more_hover_animation'] == 'display-dash' ) {
			$classes[] = 'display_dash';
		}
		
		return implode( ' ', $classes );
	}
}

if ( version_compare( ELEMENTOR_VERSION, '3.5.0', '>' ) ) {
	\Elementor\Plugin::instance()->widgets_manager->register( new StockholmCoreElementorSimpleBlogList() );
} else {
	\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new StockholmCoreElementorSimpleBlogList() );
}