<?php
namespace Stockholm\Shortcodes\SplitScrollingSectionContentItem;

use Stockholm\Shortcodes\Lib\ShortcodeInterface;

class SplitScrollingSectionContentItem implements ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'qode_split_scrolling_section_content_item';
		add_action('stockholm_qode_action_vc_map', array($this, 'vcMap'));
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		vc_map( array(
			'name' => esc_html__('Qode Split Scroling Section Content Item', 'stockholm-core'),
			'base' => $this->base,
			'icon' => 'icon-wpb-split-scrolling-section-content-item extended-custom-icon-qode',
			'category' => esc_html__('by QODE', 'stockholm-core'),
			'as_parent' => array('except' => 'vc_row'),
			'as_child' => array('only' => 'qode_split_scrolling_section_left_panel, qode_split_scrolling_section_right_panel'),
			'js_view' => 'VcColumnView',
			'params' => array(
				array(
					'type'       => 'colorpicker',
					'param_name' =>	'background_color',
					'heading'    => esc_html__('Background Color', 'stockholm-core')
				),
				array(
					'type'       => 'attach_image',
					'param_name' => 'background_image',
					'heading'    => esc_html__('Background Image', 'stockholm-core')
				),
				array(
					'type'        => 'textfield',
					'param_name'  => 'item_padding',
					'heading'     => esc_html__('Padding', 'stockholm-core'),
					'description' => esc_html__('Insert padding in format: Top Right Bottom Left (e.g. 0px 0px 1px 0px)', 'stockholm-core')
				),
				array(
					'type'       => 'dropdown',
					'param_name' =>	'alignment',
					'heading'    => esc_html__('Content Alignment', 'stockholm-core'),
					'value'      => array(
						esc_html__('Default', 'stockholm-core') => '',
						esc_html__('Left', 'stockholm-core') => 'left',
						esc_html__('Right', 'stockholm-core') => 'right',
						esc_html__('Center'	, 'stockholm-core') => 'center'
					)
				),
                array(
					'type'       => 'dropdown',
					'param_name' =>	'vertical_alignment',
					'heading'    => esc_html__('Vertical Alignment', 'stockholm-core'),
					'value'      => array(
                        esc_html__('Default', 'stockholm-core') => '',
                        esc_html__('Middle', 'stockholm-core') =>'middle',
                        esc_html__('Bottom', 'stockholm-core') => 'bottom'
					)
				)
			)
		));
	}

	public function render($atts, $content = null) {
		$args = array(
			'background_color'	=> '',
			'background_image'	=> '',
			'item_padding'		=> '',
			'alignment'			=> 'left',
            'vertical_alignment'=> ''
		);
		
		$params = shortcode_atts($args, $atts);
		extract($params);

		$params['content_style'] = $this->getContentStyles($params);
        $params['content_inner_style'] = $this->getContentInnerStyles( $params );
        $params['content_additional_classes'] = $this->getContentAdditionalClasses( $params );
		$params['content'] = $content;

		$html = stockholm_qode_get_shortcode_template_part('templates/split-scrolling-section-content-item-template', 'split-scrolling-section', '', $params);

		return $html;
	}
	
	/**
	 * Return content Style
	 *
	 * @param $params
	 * @return array
	 */
	private function getContentStyles($params) {
		$styles = array();

		if (!empty($params['item_padding'])) {
			$styles[] = 'padding: '.$params['item_padding'];
		}

		if (!empty($params['alignment'])) {
			$styles[] = 'text-align: '.$params['alignment'];
		}
		
		return implode(';', $styles);
	}

    /**
     * Return content Style
     *
     * @param $params
     * @return array
     */
    private function getContentInnerStyles($params) {
        $styles = array();

        if (!empty($params['background_color'])) {
            $styles[] = 'background-color: '.$params['background_color'];
        }

        if (!empty($params['background_image'])) {
            $url = wp_get_attachment_url($params['background_image']);
            $styles[] = 'background-image: url('. $url . ')';
        }

        return implode(';', $styles);
    }

    /**
     * Return content Style
     *
     * @param $params
     * @return array
     */
    private function getContentAdditionalClasses($params) {
        $classes = '';

        if (!empty($params['vertical_alignment'])) {
            $classes = 'qode-va-' . $params['vertical_alignment'];
        }

        return $classes;
    }
}
