<?php

if(!function_exists('stockholm_core_video_box_map')) {
    function stockholm_core_video_box_map() {

		$panel = stockholm_qode_add_admin_panel(array(
            'title' => esc_html__('Video Box', 'stockholm-core'),
            'name'  => 'panel_video_box',
            'page'  => 'elementsPage'
        ));


        $color_group = stockholm_qode_add_admin_group(array(
            'name'			=> 'color_group',
            'title'			=> esc_html__('Play Button Color Options', 'stockholm-core'),
            'description'	=> esc_html__('Setup colors for play button', 'stockholm-core'),
            'parent'		=> $panel
        ));

        $color_row = stockholm_qode_add_admin_row(array(
            'name' => 'color_row',
            'next' => true,
            'parent' => $color_group
        ));

		stockholm_qode_add_admin_field(array(
			'parent'        => $color_row,
			'type'          => 'colorsimple',
			'name'          => 'video_box_circle_color',
			'default_value' => '',
			'label'         => esc_html__('Circle Color', 'stockholm-core'),
			'description'   => ''
		));

        stockholm_qode_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'video_box_circle_hover_color',
            'default_value' => '',
            'label'         => esc_html__('Circle Hover Color', 'stockholm-core')
        ));

        stockholm_qode_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'video_box_icon_color',
            'default_value' => '',
            'label'         => esc_html__('Icon Color', 'stockholm-core')
        ));

        stockholm_qode_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'video_box_icon_hover_color',
            'default_value' => '',
            'label'         => esc_html__('Icon Hover Color', 'stockholm-core')
        ));

        $border_group = stockholm_qode_add_admin_group(array(
            'name'          => 'border_group',
            'title'         => esc_html__('Play Button Border Options', 'stockholm-core'),
            'description'   => esc_html__('Setup settings for play button border', 'stockholm-core'),
            'parent'        => $panel
        ));

        $border_row = stockholm_qode_add_admin_row(array(
            'name' => 'border_row',
            'next' => true,
            'parent' => $border_group
        ));

        stockholm_qode_add_admin_field(array(
            'parent'        => $border_row,
            'type'          => 'textsimple',
            'name'          => 'video_box_border_width',
            'default_value' => '',
            'label'         => esc_html__('Border Width', 'stockholm-core'),
            'description'   => ''
        ));

        stockholm_qode_add_admin_field(array(
            'parent'        => $border_row,
            'type'          => 'colorsimple',
            'name'          => 'video_box_border_color',
            'default_value' => '',
            'label'         => esc_html__('Border Initial Color', 'stockholm-core'),
            'description'   => ''
        ));

        stockholm_qode_add_admin_field(array(
            'parent'        => $border_row,
            'type'          => 'colorsimple',
            'name'          => 'video_box_border_hover_color',
            'default_value' => '',
            'label'         => esc_html__('Border Hover Color', 'stockholm-core'),
            'description'   => ''
        ));

        $size_group = stockholm_qode_add_admin_group(array(
            'name'          => 'size_group',
            'title'         => esc_html__('Play Button Size Options', 'stockholm-core'),
            'description'   => esc_html__('Setup size for play button border', 'stockholm-core'),
            'parent'        => $panel
        ));

        $size_row = stockholm_qode_add_admin_row(array(
            'name' => 'size_row',
            'next' => true,
            'parent' => $size_group
        ));

        stockholm_qode_add_admin_field(array(
            'parent'        => $size_row,
            'type'          => 'textsimple',
            'name'          => 'video_box_height_width',
            'default_value' => '',
            'label'         => esc_html__('Play Button Height/Width', 'stockholm-core'),
            'description'   => ''
        ));
	}

    add_action('stockholm_qode_action_options_elements_page_map', 'stockholm_core_video_box_map');
}