<?php

if ( ! class_exists( 'Stockholm_Qode_Quick_View_For_WooCommerce' ) ) {
	class Stockholm_Qode_Quick_View_For_WooCommerce {
		private static $instance;

		public function __construct() {

			if ( defined( 'QODE_QUICK_VIEW_FOR_WOOCOMMERCE_VERSION' ) ) {

				add_action( 'stockholm_qode_action_woocommerce_additional_info', array( $this, 'render_button' ), 1 );
				
				add_filter( 'qode_quick_view_for_woocommerce_filter_is_product_image_enabled', '__return_false' );
				
				add_action( 'qode_quick_view_for_woocommerce_action_product_image', array( $this, 'replace_gallery' ), 30 );
				
				add_filter( 'qode_quick_view_for_woocommerce_filter_is_product_meta_enabled', '__return_false' );

				add_filter( 'qode_quick_view_for_woocommerce_filter_button_loop_position_default_value', array( $this, 'set_quick_view_button_loop_position_default_value' ) );

				//Add additional html around single meta
				add_action('qode_quick_view_for_woocommerce_action_product_summary', 'stockholm_qode_woocommerce_share_tag_before', 32);
				add_action('qode_quick_view_for_woocommerce_action_product_summary', 'stockholm_qode_woocommerce_share_tag_after', 35);

				//Add social share (default woocommerce_share)
				add_action( 'qode_quick_view_for_woocommerce_action_product_summary', 'stockholm_qode_qode_woocommerce_share', 32 );
			}
		}

		/**
		 * @return Stockholm_Qode_Quick_View_For_WooCommerce
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function render_button() {

			if ( class_exists( 'Qode_Quick_View_For_WooCommerce_Quick_View_Button_Shortcode' ) ) {
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo Qode_Quick_View_For_WooCommerce_Quick_View_Button_Shortcode::call_shortcode();
			}
		}
		
		public function replace_gallery() {
			stockholm_qode_woocommerce_show_product_images();
		}

		public function set_quick_view_button_loop_position_default_value() {
			return 'shortcode';
		}
	}
	
	Stockholm_Qode_Quick_View_For_WooCommerce::get_instance();
}
