<?php

if ( ! class_exists( 'Stockholm_Qode_Wishlist_For_WooCommerce' ) ) {
	class Stockholm_Qode_Wishlist_For_WooCommerce {
		private static $instance;

		public function __construct() {

			if ( defined( 'QODE_WISHLIST_FOR_WOOCOMMERCE_VERSION' ) ) {

				add_filter( 'qode_wishlist_for_woocommerce_filter_add_to_wishlist_behavior_default_value', array( $this, 'set_default_add_to_wishlist_behavior' ) );

				add_filter( 'qode_wishlist_for_woocommerce_filter_button_loop_position_default_value', array( $this, 'set_default_button_loop_position' ) );

				add_filter( 'qode_wishlist_for_woocommerce_filter_add_to_wishlist_loop_type_default_value', array( $this, 'set_default_add_to_wishlist_loop_type' ) );

				add_action( 'init', array( $this, 'set_button_loop_position' ), 15 );

				add_filter( 'qode_wishlist_for_woocommerce_filter_button_single_position_default_value', array( $this, 'set_default_add_to_wishlist_single_position' ) );

				add_filter( 'qode_wishlist_for_woocommerce_filter_enable_share_default_value', array( $this, 'enable_social_share' ) );
			}
		}

		/**
		 * @return Stockholm_Qode_Wishlist_For_WooCommerce
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function set_default_add_to_wishlist_behavior() {
			return 'view';
		}

		public function set_default_button_loop_position() {
			return 'shortcode';
		}

		public function set_default_add_to_wishlist_loop_type() {
			return 'icon';
		}

		public function set_button_loop_position() {
			$button_loop_position = qode_wishlist_for_woocommerce_get_option_value( 'admin', 'qode_wishlist_for_woocommerce_button_loop_position' ) ?? '';

			//Add wishlist button shop archive pages
			if ( 'shortcode' === $button_loop_position ) {
				add_action( 'stockholm_qode_action_woocommerce_additional_info', array( $this, 'render_button' ), 2 );
			}
		}

		public function render_button() {

			if ( class_exists( 'Qode_Wishlist_For_WooCommerce_Add_To_Wishlist_Shortcode' ) ) {
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo Qode_Wishlist_For_WooCommerce_Add_To_Wishlist_Shortcode::call_shortcode();
			}
		}

		public function set_default_add_to_wishlist_single_position() {
			return 'after-add-to-cart-form';
		}

		public function enable_social_share() {
			return 'no';
		}
	}

	Stockholm_Qode_Wishlist_For_WooCommerce::get_instance();
}
