<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order $order
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="woocommerce-order">
	<?php /*** Our code modification inside Woo template - begin ***/ ?>
	
	<?php if ( $order ) :
		
		do_action( 'woocommerce_before_thankyou', $order->get_id() ); ?>
		
		<?php if ( $order->has_status( 'failed' ) ) : ?>
			
			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed woocommerce-message"><?php esc_html_e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'stockholm' ); ?></p>
			
			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions woocommerce-message">
				<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'stockholm' ) ?></a>
				<?php if ( is_user_logged_in() ) : ?>
					<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html_e( 'My account', 'stockholm' ); ?></a>
				<?php endif; ?>
			</p>
		
		<?php else : ?>

			<?php wc_get_template( 'checkout/order-received.php', array( 'order' => $order ) ); ?>

			<ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details clearfix">
				
				<li class="woocommerce-order-overview__order order">
					<span><?php esc_html_e( 'Order number:', 'stockholm' ); ?></span>
					<p><?php echo esc_attr( $order->get_order_number() ); ?></p>
				</li>
				
				<li class="woocommerce-order-overview__date date">
					<span><?php esc_html_e( 'Date:', 'stockholm' ); ?></span>
					<p><?php echo wc_format_datetime( $order->get_date_created() ); ?></p>
				</li>
				
				<?php if ( is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email() ) : ?>
					<li class="woocommerce-order-overview__email email">
						<span><?php esc_html_e( 'Email:', 'stockholm' ); ?></span>
						<p><?php echo esc_attr( $order->get_billing_email() ); ?></p>
					</li>
				<?php endif; ?>
				
				<li class="woocommerce-order-overview__total total">
					<span><?php esc_html_e( 'Total:', 'stockholm' ); ?></span>
					<p><?php echo stockholm_qode_get_module_part( $order->get_formatted_order_total() ); ?></p>
				</li>
				
				<?php if ( $order->get_payment_method_title() ) : ?>
					<li class="woocommerce-order-overview__payment-method method">
						<span><?php esc_html_e( 'Payment method:', 'stockholm' ); ?></span>
						<p><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></p>
					</li>
				<?php endif; ?>
			</ul>
			<div class="clear"></div>
		
		<?php endif; ?>
		
		<div class="order-details-wrapper">
			<?php do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() ); ?>
			<?php do_action( 'woocommerce_thankyou', $order->get_id() ); ?>
		</div>
	
	<?php else : ?>

		<?php wc_get_template( 'checkout/order-received.php', array( 'order' => false ) ); ?>

	<?php endif; ?>
	
	<?php /*** Our code modification inside Woo template - end ***/ ?>
</div>