(function ($) {
    'use strict';

    var horizontalyScrollingPortfolioList = {};
    qode.modules.horizontalyScrollingPortfolioList = horizontalyScrollingPortfolioList;

    horizontalyScrollingPortfolioList.qodeOnDocumentReady = qodeOnDocumentReady;

    $(document).ready(qodeOnDocumentReady);
    $(window).on('load', qodeOnWindowLoad());

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function qodeOnDocumentReady() {
        qodeInitHorizontalyScrollingPortfolioList();
    }

    /*
     ** All functions to be called on $(window).load() should be in this function
     */
    function qodeOnWindowLoad() {
        qodeInitElementorHorizontalyScrollingPortfolioList();
    }

    function qodeInitHorizontalyScrollingPortfolioList() {
        var list = $('.qode-horizontaly-scrolling-portfolio-holder');

        if (list.length && $window_width >= 768) {
            var listInner = list.find('.qode-hspl-inner'),
                items = list.find('.qode-hspl-item'),
                marginHolder = list.find('.qode-hspl-margin-holder'),
                customItem = list.find('.qode-hspl-custom'),
                listWidth = 0,
                widthVal = 412,
                customItemWidth = 0,
                decreaseHeightHeader = list.data('header-decrease'),
                decreaseHeightContentBottom = list.data('content-bottom-decrease');

            var widthCalcs = function () {
                //custom sizing
                if ($window_width <= 1440 && $window_width > 1280) {
                    if ($window_width <= 645) {
                        widthVal = 412;
                    } else {
                        widthVal = 412;
                    }
                } else if ($window_width <= 1280 && $window_width > 1024) {
                    widthVal = 412;
                } else if ($window_width <= 1024 && $window_width > 768) {
                    widthVal = 412;
                } else if ($window_width === 768) {
                    widthVal = 390;
                } else {
                    widthVal = 412;
                }

                listWidth = 0;
                if (customItem.length) {
                    if ($window_width > 1444) {
                        customItemWidth = parseInt(2.1 * widthVal);
                    } else if ($window_width > 1024) {
                        customItemWidth = parseInt(1.53 * widthVal);
                    } else {
                        customItemWidth = widthVal;
                    }
                    customItem.width(customItemWidth);
                    listInner.css('marginLeft', customItemWidth + 'px'); //set slider left margin only if there is custom element which is static
                    listInner.css('paddingRight', customItemWidth + 'px'); //set slider left margin only if there is custom element which is static
                }
                items.each(function () {
                    var item = $(this),
                        itemWidth = widthVal;

                    listWidth += itemWidth;
                    item.width(itemWidth);
                });
                if (qode_htmlEl.hasClass('touch')) {
                    listWidth += customItemWidth;
                }
                listInner.width(listWidth);
            }

            var heightCalcs = function () {
                var height = $window_height;
            }

            heightCalcs();
            widthCalcs();

            if (qode_body.hasClass('qode-smooth-page-transitions-preloader')) {
                $(document).on('edgtfLoaderRemoved', function () {
                    listInner.addClass('qode-ready');
                });
            } else {
                listInner.addClass('qode-ready');
            }

            $(window).resize(function () {
                heightCalcs();
                widthCalcs();
            });

            if (qode_htmlEl.hasClass('touch')) {
                if( $window_width >= 768 ) {
                    //custom horizontal touch nav using hammer
                    var section = document.querySelector('.qode-hspl-inner'),
                        $section = $('.qode-hspl-inner'),
                        sectionH = new Hammer(section),
                        transformVal = 0;

                    var moveContent = function (delta) {
                        $section.css('transform', 'translate3d(' + delta + 'px, 0, 0)')
                    }

                    sectionH.on("swipe", function (ev) {
                        if (ev.deltaX > 0) {
                            transformVal += ev.distance;
                            transformVal = Math.min(0, transformVal);
                        } else {
                            transformVal -= ev.distance;
                            transformVal = -Math.min(listWidth - $section.parent().width() - parseInt($section.find('article:last-child').css('margin-right')), Math.abs(transformVal));
                        }

                        moveContent(transformVal);
                    });

                    $(window).on('resize', function () {
                        //prevent overscroll
                        if (Math.abs(transformVal) >= listWidth - $section.parent().width() - parseInt($section.find('article:last-child').css('margin-right'))) {
                            moveContent(-listWidth + $section.parent().width() + parseInt($section.find('article:last-child').css('margin-right')));
                        }
                    });
                }
            } else {
                //custom smooth horizontal scroll using virtual scroll
                var section = document.querySelector('.qode-hspl-inner'),
                    sectionWidth = section.getBoundingClientRect().width,
                    targetX = 0,
                    currentX = 0,
                    ease = 0.08,
                    coeff = parseInt(list.parent().css('paddingLeft')) * 2
                        - parseInt(window.getComputedStyle(section.querySelector('article:last-child')).marginRight); //adj.

                qode_htmlEl
                    .add(qode_body)
                    .addClass('qode-overflow-hidden');

                //edgtf.modules.common.edgtfDisableScroll();

                window.addEventListener('resize', function () {
                    coeff = parseInt(list.parent().css('paddingLeft')) * 2
                        - parseInt(window.getComputedStyle(section.querySelector('article:last-child')).marginRight);
                    sectionWidth = section.getBoundingClientRect().width;
                })

                VirtualScroll.on(function (e) {
                    targetX += e.deltaY;
                    targetX = Math.max((sectionWidth - window.innerWidth + coeff) * -1, targetX);
                    targetX = Math.min(0, targetX);
                });

                var changeFixedLogoOnMouseMove = function () {
                    if (qode_body.hasClass('qode-fixed-only-logo') && qode_body.hasClass('qode-with-uploaded-fixed-logo')) {

                        var x1 = 0,
                            y1 = 0,
                            x2,
                            y2,
                            counter = 0;

                        $(document).on('mousemove', function (e) {
                            x2 = e.clientX;
                            y2 = e.clientY;
                        });

                        setInterval(function () {
                            counter++;
                            var mouseMoved = (x1 !== x2 && y1 !== y2); //check if mouse has changed position

                            if (counter > 1 && mouseMoved) { //counter is there to prevent changing logo in first iteration since coordinates will always be different
                                qode_body.addClass('qode-mouse-is-moving');
                                qode_body.removeClass('qode-mouse-is-idle');
                            } else {
                                qode_body.addClass('qode-mouse-is-idle');
                                qode_body.removeClass('qode-mouse-is-moving');
                            }
                            x1 = x2;
                            y1 = y2;
                        }, 200);
                    }
                }

                var changeFixedLogoOnScroll = function (targetX, currentX) {
                    var scrollOffset = Math.abs(targetX - currentX);

                    if (scrollOffset < 5) {
                        qode_body.addClass('qode-slider-is-idle');
                        qode_body.removeClass('qode-slider-is-moving');
                    } else {
                        qode_body.addClass('qode-slider-is-moving');
                        qode_body.removeClass('qode-slider-is-idle');
                    }
                }

                var customContentFadeout = function (currentX) {
                    if (customItem.length) {
                        var customItemContent = customItem.find('.qode-hspl-custom-content'),
                            delta = Math.abs(currentX),
                            customItemWidth = customItem.outerWidth(),
                            indent = 2 * customItemWidth / 3;

                        if (delta <= indent) {
                            var offset = 1 - delta / indent;
                            customItemContent.css('opacity', offset);
                        } else {
                            customItemContent.css('opacity', 0);
                        }

                    }
                }

                var performScroll = function () {
                    requestAnimationFrame(performScroll);
                    //changeFixedLogoOnMouseMove();
                    changeFixedLogoOnScroll(targetX, currentX);
                    customContentFadeout(currentX);
                    currentX += (targetX - currentX) * ease;
                    var t = 'translate3d(' + currentX + 'px, 0px, 0px)';
                    var s = section.style;
                    s["transform"] = t;
                    s["webkitTransform"] = t;
                    s["mozTransform"] = t;
                    s["msTransform"] = t;
                }

                performScroll();
            }
        }
    }

    function qodeInitElementorHorizontalyScrollingPortfolioList(){
        $j(window).on('elementor/frontend/init', function () {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/qode_horizontaly_scrolling_portfolio_list.default', function() {
                qodeInitHorizontalyScrollingPortfolioList();
            } );
        });
    }
})(jQuery);