<?php
namespace Stockholm\Shortcodes\VideoBox;

use Stockholm\Shortcodes\Lib\ShortcodeInterface;


class VideoBox implements ShortcodeInterface {
    /**
     * @var string
     */
    private $base;

    /**
     * Sets base attribute and registers shortcode with Visual Composer
     */
    public function __construct() {
        $this->base = 'qode_video_box';
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base attribute
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        vc_map(array(
            'name' => esc_html__('Video Box', 'stockholm-core'),
            'base' => 'qode_video_box',
            'category' => esc_html__('by SELECT', 'stockholm-core'),
            'icon' => 'extended-custom-icon icon-wpb-video-box',
            'params' => array(
				array(
					'type'        => 'textfield',
					'param_name'  => 'custom_class',
					'heading'     => esc_html__( 'Custom CSS Class', 'stockholm-core' ),
					'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'stockholm-core' )
				),
				array(
					'type'       => 'textfield',
					'param_name' => 'video_link',
					'heading'    => esc_html__( 'Video Link', 'stockholm-core' )
				),
				array(
					'type'        => 'attach_image',
					'param_name'  => 'video_image',
					'heading'     => esc_html__( 'Video Image', 'stockholm-core' ),
					'description' => esc_html__( 'Select image from media library', 'stockholm-core' )
				),
				array(
					'type'       => 'colorpicker',
					'param_name' => 'play_button_color',
					'heading'    => esc_html__( 'Play Button Color', 'stockholm-core' )
				),
				array(
					'type'       => 'textfield',
					'param_name' => 'play_button_size',
					'heading'    => esc_html__( 'Play Button Size (px)', 'stockholm-core' )
				),
				array(
					'type'        => 'attach_image',
					'param_name'  => 'play_button_image',
					'heading'     => esc_html__( 'Play Button Custom Image', 'stockholm-core' ),
					'description' => esc_html__( 'Select image from media library. If you use this field then play button color and button size options will not work', 'stockholm-core' )
				),
				array(
					'type'        => 'attach_image',
					'param_name'  => 'play_button_hover_image',
					'heading'     => esc_html__( 'Play Button Custom Hover Image', 'stockholm-core' ),
					'description' => esc_html__( 'Select image from media library. If you use this field then play button color and button size options will not work', 'stockholm-core' )
				)
            )
        ) );
    }

    /**
     * Renders HTML for video shortcode
     *
     * @param array $atts
     * @param null $content
     *
     * @return string
     */
    public function render($atts, $content = null) {

        $args = array(
			'custom_class'            => '',
			'video_link'              => '#',
			'video_image'             => '',
			'play_button_color'       => '',
			'play_button_size'        => '',
			'play_button_image'       => '',
			'play_button_hover_image' => ''
        );

        $params = shortcode_atts($args, $atts);

        extract($params);

		$params['holder_classes']     = $this->getHolderClasses( $params );
		$params['play_button_styles'] = $this->getPlayButtonStyles( $params );

        $html = stockholm_qode_get_shortcode_template_part('templates/video-box-template', 'video-box', '', $params);

        return $html;
    }

	private function getHolderClasses( $params ) {
		$holderClasses = array();

		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['video_image'] ) ? 'qodef-vb-has-img' : '';

		return implode( ' ', $holderClasses );
	}

	private function getPlayButtonStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['play_button_color'] ) ) {
			$styles[] = 'color: ' . $params['play_button_color'];
		}

		if ( ! empty( $params['play_button_size'] ) ) {
			$styles[] = 'font-size: ' . stockholm_qode_filter_px( $params['play_button_size'] ) . 'px';
		}

		return implode( ';', $styles );
	}

}